package mcfall.math;

/**
 * The Class LineSegment represents a line between 2 points.  One of which is considered a start point and the other is considered an ending point.  
 */
public class LineSegment {
	
	Point start,end;
	
	/**
	 * Instantiates a new line segment.
	 * 
	 * @param start the start
	 * @param end the end
	 */
	public LineSegment(Point start,Point end) {
		setStart(start);
		setEnd(end);
	}
	
	/**
	 * Gets the starting point.
	 * 
	 * @return the starting point
	 */
	public Point getStart() {
		try {
			return Point.fromColumnMatrix(this.start.duplicate());
		} catch (IncompatibleMatrixException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			return null;
		}
	}
	
	/**
	 * Sets the starting point.
	 * 
	 * @param p the new start point
	 */
	public void setStart(Point p) {
		try {
			this.start = Point.fromColumnMatrix(p.duplicate());
		} catch (IncompatibleMatrixException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}
	
	/**
	 * Gets the ending point.
	 * 
	 * @return the ending point
	 */
	public Point getEnd() {
		try {
			return Point.fromColumnMatrix(this.end.duplicate());
		} catch (IncompatibleMatrixException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			return null;
		}
	}
	
	/**
	 * Sets the ending point.
	 * 
	 * @param p the new ending point.
	 */
	public void setEnd(Point p) {
		try {
			this.end = Point.fromColumnMatrix(p.duplicate());
		} catch (IncompatibleMatrixException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}
	
	
	@Override
	public String toString() {
		return "Segment["+getStart()+":"+getEnd()+"]";
	}
	
	
	@Override
	public boolean equals(Object o) {
		if(o instanceof LineSegment) {
			return this.equals((LineSegment)o);
		}
		return false;
	}
	
	/**
	 * Tests to see if one LineSegment equals another.  Line segments that are equivalent may have different orientations
	 * 
	 * @param ls the ls
	 * 
	 * @return a boolean telling if the LineSegment objects are equivalent or not
	 */
	public boolean equals(LineSegment ls) {
		return (this.getStart().equals(ls.getStart()) && this.getEnd().equals(ls.getEnd())) || 
		(this.getStart().equals(ls.getEnd()) && this.getEnd().equals(ls.getStart()));
	}
	
	/**
	 * Length.
	 * 
	 * @return the length
	 */
	public double length() {
		return start.distance(end);
	}
	
	/**
	 * Gets the vector going from one point to the other.
	 * 
	 * @return the vector
	 */
	public Vector getVector() {
		return end.subtract(start);
	}
	
	/**
	 * Gets the mid point.
	 * 
	 * @return the mid point
	 */
	public Point getMidPoint() {
		try {
			return Point.fromColumnMatrix(start.add(end).scalarMultiply(0.5));
		} catch (IncompatibleMatrixException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			return null;
		}
	}
}
